clear all
set more off

** Program to create dataset of WM-store entries

cd "\IRI data"

import delimited "driving_times.csv"

drop own wm*

merge m:1 iri_key using wm_entry_id.dta // generated ("iri_wm_match_15") by wm_iri_distance.sas
keep if _merge==3
drop _merge

merge m:1 iri_key using wm_entry_week.dta // generated ("temp3") by wm_iri_distance.sas
keep if _merge==3
drop _merge

preserve
	forvalues i=1/24 {
		rename dis`i' dis
		rename time`i' time
		rename wm_id`i' wmid
		rename wm15_week_`i' week
		keep iri_key dis time wmid week
		drop if wmid == 0
		save entries_`i'.dta, replace
		restore, preserve
		}
		
	use entries_24.dta, replace
	forvalues i=1/23 {
		append using entries_`i'.dta
		erase entries_`i'.dta
		}
	erase entries_24.dta
	restore, not
	
	duplicates drop iri_key wmid, force
	
	xtset iri_key week
	sort iri_key week
	by iri_key, sort: gen entry = _n
	
	local d = 11
	gen ls`d' = (dis <= `d')
	sort iri_key ls`d' week
	by iri_key ls`d', sort: gen entry_ls`d' = _n
	replace entry_ls`d' = . if ls`d' == 0
	drop ls`d'
	
*	keep if week >= 1 & week <= 573
	
	save entries_`d'.dta, replace
	
** Set mile driving distance threshold

drop if entry_ls`d' == .
drop entry
rename entry_ls`d' entry

** Reshape

reshape wide dis time wmid week, i(iri_key) j(entry)

** Save

drop time*
saveold entries_wide_`d'.dta, replace	
	